#pragma once

#include <string>


class Button
{

  public:

    std::string         m_SectionNormal;
    std::string         m_SectionMouseOver;
    std::string         m_SectionPushed;

    bool                m_MouseOver;
    bool                m_Pushed;

    std::string         m_Text;

    unsigned int        m_Color;

    int                 m_ID;

    int                 m_X;
    int                 m_Y;
    int                 m_W;
    int                 m_H;


    Button( int X = 0, int Y = 0, int W = 20, int H = 20, 
            const std::string& ImageNormal = std::string(), 
            const std::string& ImageMouseOver = std::string(), 
            const std::string& ImagePushed = std::string(),
            int ButtonID = -1 );
    Button( int X, int Y, int W, int H, 
            const std::string& ImageNormal, 
            const std::string& ImageMouseOver, 
            const std::string& ImagePushed,
            const std::string& Text,
            int ButtonID = -1 );
    virtual ~Button();



    virtual bool        UpdateMouse( int Buttons, int X, int Y );

    void                Render();

};
